<?php
require_once '../auth/auth.php';
require_once '../config/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

try {
    $product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;
    
    if ($product_id <= 0) {
        throw new Exception('Invalid product ID');
    }
    
    $stmt = $pdo->prepare("SELECT serial_number FROM product_serial_numbers WHERE product_id = ? AND status = 'available'");
    $stmt->execute([$product_id]);
    $serials = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if ($serials && count($serials) > 0) {
        echo json_encode([
            'success' => true,
            'serial_numbers' => $serials
        ]);
    } else {
        // Check if there are any serials at all for this product
        $stmt2 = $pdo->prepare("SELECT COUNT(*) FROM product_serial_numbers WHERE product_id = ?");
        $stmt2->execute([$product_id]);
        $total = $stmt2->fetchColumn();
        
        if ($total > 0) {
            // There are serials but none are available (all sold)
            echo json_encode([
                'success' => true,
                'serial_numbers' => [],
                'message' => 'All serial numbers for this product have been sold.'
            ]);
        } else {
            // No serials exist for this product at all
            echo json_encode([
                'success' => true,
                'serial_numbers' => [],
                'message' => 'No serial numbers have been added to this product yet.'
            ]);
        }
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} 